/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.service;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.vcard.vcardapplication.dao.UserDao;
import com.vcard.vcardapplication.request.ResponseBannerDto;
import com.vcard.vcardapplication.service.FileService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserPhotoService {
    @Autowired
    private FileService fileService;
    @Autowired
    private UserDao userDao;

    public ResponseBannerDto addprofile(MultipartFile file) {
        try {
            if (file.isEmpty()) {
                throw new IllegalArgumentException("file cannot be empty");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                throw new IllegalArgumentException("Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/mydpro/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.mydpro.com" + remotePath;
            ResponseBannerDto bannerDto = new ResponseBannerDto(uploadedUrl);
            return new ResponseBannerDto(uploadedUrl);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error occurred while processing the file: " + e.getMessage());
        }
    }

    public byte[] generateQRCodeImage(String text, int width, int height) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height);
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
        return pngOutputStream.toByteArray();
    }
}

