/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.service;

import com.vcard.vcardapplication.dao.UserDao;
import com.vcard.vcardapplication.model.User;
import com.vcard.vcardapplication.request.PasswordChangeRequest;
import com.vcard.vcardapplication.request.ResponseDto;
import com.vcard.vcardapplication.request.UserDto;
import com.vcard.vcardapplication.service.AuthenticationService;
import com.vcard.vcardapplication.service.OTPService;
import com.vcard.vcardapplication.util.JavaSendapi;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PasswordChangeServiceImpl {
    @Autowired
    AuthenticationService authenticationService;
    @Autowired
    PasswordEncoder encoder;
    @Autowired
    UserDao userDao;
    @Autowired
    JavaSendapi javaSendapi;

    public ResponseEntity<?> changePassword(PasswordChangeRequest changeRequest, String token) {
        try {
            PasswordChangeRequest password = this.authenticationService.getPassDetails(token);
            if (!this.encoder.matches((CharSequence)changeRequest.getOldpassword(), password.getOldpassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Old Password is Incorrect");
            }
            if (!changeRequest.getNewpassword().equals(changeRequest.getReenterpassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"New Password and re-enter password do not match");
            }
            Optional userOtp = this.userDao.findById(changeRequest.getId());
            if (userOtp.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"User not found");
            }
            User user = (User)userOtp.get();
            String newpassword = changeRequest.getNewpassword();
            user.setPassword(this.encoder.encode((CharSequence)newpassword));
            this.userDao.save(user);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Password change successfully!!!");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while change password" + e.getMessage()));
        }
    }

    public ResponseDto forgotPassword(UserDto request) {
        try {
            System.out.println("request.getEmail(): " + request.getEmail());
            if (request.getEmail() == null && request.getRole() == null) {
                return new ResponseDto("Error", "Email is required.", "Test");
            }
            Optional user = this.userDao.findByEmail(request.getEmail());
            if (!user.isPresent()) {
                return new ResponseDto("Error", "User not found with the provided email.", "Test");
            }
            if (request.getOtp() == null) {
                return new ResponseDto("Error", "OTP is required.", "Test");
            }
            if (request.getPassword() == null) {
                return new ResponseDto("Error", "New password is required.", "Test");
            }
            boolean isVerified = OTPService.verifyOTP((String)request.getEmail(), (String)request.getOtp());
            if (!isVerified) {
                return new ResponseDto("Error", "Invalid OTP.", "Test");
            }
            ((User)user.get()).setPassword(this.encoder.encode((CharSequence)request.getPassword()));
            this.userDao.save((User)user.get());
            return new ResponseDto("Success", "Password changed successfully.", "Test");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseDto("Error", "An unexpected error occurred. Please try again later.", "Test");
        }
    }

    public ResponseDto sendOtp(UserDto request) {
        try {
            System.out.println("Generating OTP for account creation...");
            String otp = OTPService.generateOTP();
            System.out.println("OTP generated: " + otp);
            OTPService.storeOTPInDatabase((String)request.getEmail(), (String)otp);
            System.out.println("OTP stored in the database.");
            String body = "<html><p>Welcome to Vcard! To complete your account setup, please use the OTP below:</p><p><strong>Your OTP: " + otp + "</strong></p><p>This OTP is valid for the next 10 minutes. Please enter it on the registration page to verify your email address.</p><p>If you did not request an account with Vcard, please ignore this email.</p><br><p>Best regards,</p><p>The Vcard Team</p><p><a href='mailto:support@vcard.com'>support@vcard.com</a></p><p><a href='https://vcard.com'>vcard.com</a></p></html>";
            String subject = "vcard Account Verification OTP";
            this.javaSendapi.sendMailWithAttachment(request.getEmail(), body, subject);
            return new ResponseDto("Success", "OTP has been sent to your email for account creation.", "Info");
        }
        catch (Exception e) {
            return new ResponseDto("Error", "Something went wrong while sending the OTP.", "Error");
        }
    }

    public String otpverification(UserDto userDto) {
        try {
            boolean verifyOTP = OTPService.verifyOTP((String)userDto.getEmail(), (String)userDto.getOtp());
            if (verifyOTP) {
                return "Success OTP verified successfully. Account creation can proceed.Info";
            }
            return "Error Invalid OTP. Please check and try again.Info";
        }
        catch (Exception e) {
            return "ErrorAn error occurred while verifying the OTP.Error";
        }
    }
}

